function [integr] = int_Wpoltot(quantity,geop,model)
%function [integral] = int_Wpoltot(quantity,g,model)
% integrate poloidal field energy over totao plasma volume
%
% WI = 1/(8*pi^2*mu0)* int g2/V' *(dpsi/drho).^2 drho
%
% quantity: quantity to be integrated on gauss grid (usually dpsi/drho for
% this case)
% g: geometry
% model: RAPTOR model

% #codegen

mu0 = 4e-7*pi;

integr = 1/(8*pi^2*mu0)*sum(bsxfun(@times,model.rgrid.wgauss.*(geop.g2./geop.Vp),quantity));


return
