function [upl,dupl_dx,dupl_dxdot] = eval_upl(x,xdot,g,gdot,~,model,gauss)
% #codegen
% upl   = dpsi/dt - Phibdot/(2*Phib)*rho*dpsi/drho
% (from Eq. 5 in RAPTOR equation summary)

if nargout>1
  [psidot, dpsidot_dxdot] = eval_psi(xdot,[],[],model,gauss);
  [psip,dpsip_dx] = eval_psip(x,[],[],model,gauss);
else
  psidot = eval_psi(xdot,[],[],model,gauss);
  psip = eval_psip(x,[],[],model,gauss);
end
if gauss
  rho = model.rgrid.rhogauss;
else
  rho = model.rgrid.rho;
end

Phibdot = eval_Phib([],gdot,[],model,[]);
Phib = eval_Phib([],g,[],model,[]);

upl  = psidot - Phibdot/(2*Phib).*rho.*psip;
if nargout>1
  dupl_dx = - Phibdot/(2*Phib).*bsxfun(@times,rho,dpsip_dx);
  dupl_dxdot = dpsidot_dxdot;
end

return