function [te,dte_dx] = eval_te(x,~,v,model,gauss)
% function [te,dte_dx] = eval_te(x,g,v,model,whichgrid)
% #codegen
use_core_spline_base = hmode_spline_base_active(v,model);
% implement later: transition model.hmode.vind.activation in time dependent
% run
if ~use_core_spline_base
  % init
  if ~gauss;
    dte_dx = zeros(model.rgrid.nrho,numel(x));
  else
    dte_dx = zeros(model.rgrid.nrhogauss,numel(x));
  end

  switch model.te.method
    case 'state'
      % te is directly specified by x
      if gauss
        dte_dtehat = model.te.Lamgauss;
      else
        dte_dtehat = model.te.Lam;
      end
      te = dte_dtehat*x(model.te.xind,:);
    otherwise
      error('model.te.method = %s not implemented',model.te.method)
  end
  
  if nargout>1
    dte_dx(:,model.te.xind) = dte_dtehat;
  end
else
  % this is the case for special H-mode splines
  % init
  if ~gauss;
    dte_dx = zeros(model.rgrid.nrho,numel(x));
  else
    dte_dx = zeros(model.rgrid.nrhogauss,numel(x));
  end
  switch model.te.method
    case 'state'
      if size(v,2)>1 
        if any(v(model.hmode.vind.activation, :)) && ~all(v(model.hmode.vind.activation, :))
          error('eval_te for time dependent V not implemented for varying spline basis')
        end
      end
      % te is specified by x and Te(rho=1)
      if gauss
        dte_dxx = model.te.Lamgauss_hmode;
        dte_dtehat = model.te.Lamgauss_hmode(:, 1:end-1);
      else
        dte_dxx = model.te.Lam_hmode;
        dte_dtehat = model.te.Lam_hmode(:, 1:end-1);
      end
      xx = [x(model.te.xind,:); v(model.hmode.vind.te_rhoedge, :)./model.te.scal];
      te = dte_dxx*xx;
    otherwise
      error('model.te.method = %s not implemented',model.te.method)
  end
  
  if nargout>1
    dte_dx(:,model.te.xind) = dte_dtehat;
  end
end

return
