function tauE_H98 = eval_tauEH98_from_traces(Ip, B0, ne0, Plossnet, R0, epsilon, kappa, Ai)
% Eq. 20 ITER Physics Expert Group on Confinement and Transport et al 1999 Nucl. Fusion 39 2175

Ipe6 = Ip/1e6;
ne19 = ne0/1e19;
Plossnete6 = Plossnet/1e6;

tauE_H98 = 5.62e-2* Ipe6.^0.93 .* B0.^0.15 .* ne19.^0.41 .* Plossnete6.^-0.69 .*...
R0.^1.97 .* epsilon.^0.58 .* kappa.^0.78 .* Ai.^0.19;

end