function tauE_H98 = eval_tauEH98(x,g,v,model,~,varargin) 
% Energy confinement time scaling law for H-mode: IPB 1999, H98(y,2)

if nargin==0
    error('Power loss has to be an input');
else
    Ploss = varargin{1};
end

% Elongation
kappa = eval_kappa(x,g,v,model,false);
% Aspect ratio
epsilon = eval_epsilon(x,g,v,model,false);
% Magnetic field
B0 = eval_B0(x,g,v,model,false); 
% Plasma current
Ip = eval_Ipl(x,g,v,model,false);
% Electron density
ne = eval_ne(x,g,v,model,true);
% tau_scaling: 
tauE_H98 = eval_tauEH98_from_traces(Ip(end), B0, ne(1), Ploss, R0, epsilon(end), kappa(end), model.atom.Ai);

return