function [pprime_uni, ttprime_uni, rhopsiN_uniform, varargout] = eval_pp_ttp_on_uniform_rhopsi(xk, gk, vk, model)
% Interpolate in uniform rhopsiN grid for LIUQE input 

gauss = true;

pprime_RAP = eval_pprime(xk,[],vk,model,gauss);
ttprime_RAP  = eval_ttprime(xk,gk,vk,model,gauss);
psiN_RAP = eval_psiN(xk,[],[],model,gauss);
rhopsiN_RAP = sqrt(psiN_RAP);
if nargout>3 % extra outputs that can be requested for debugging purposes
  p_RAP = eval_press(xk,gk,vk,model,gauss);
  q_RAP = eval_q(xk,gk,[],model,gauss);
  jtor_RAP = eval_jtor(xk,gk,[],model,gauss);
  Ip_RAP = eval_Ipl(xk,gk,[],model,gauss);
end

rhopsiN_uniform = sqrt(linspace(0,1,400)); % uniform rhopsiN grid with 400 grid points

pprime_uni = interp1(rhopsiN_RAP , pprime_RAP, rhopsiN_uniform, 'spline','extrap')';
ttprime_uni = interp1(rhopsiN_RAP, ttprime_RAP, rhopsiN_uniform, 'spline','extrap')';

if nargout>3
  %  p, q, jtor, Ip
  varargout{1} = interp1(rhopsiN_RAP, p_RAP, rhopsiN_uniform, 'spline','extrap')';
  varargout{2} = interp1(rhopsiN_RAP, q_RAP, rhopsiN_uniform, 'spline','extrap')';
  varargout{3} = interp1(rhopsiN_RAP, jtor_RAP, rhopsiN_uniform, 'spline','extrap')';
  varargout{4} = interp1(rhopsiN_RAP, Ip_RAP, rhopsiN_uniform, 'spline','extrap')';
end

end