function [g23or] = eval_g23or(~,g,~,model,gauss)
% function [g23or] = eval_g23or(x,g,v,model,whichgrid)
% computes g2*g3/rho = gg2*rho*g3 / H^2
% #codegen

if gauss
  rho = model.rgrid.rhogauss;
else
  rho = model.rgrid.rho;
end

g3 = eval_g3([],g,[],model,gauss); 
H = eval_H([],g,[],model,gauss); % dpsi/dV
gg2 = eval_gg2([],g,[],model,gauss);
g23or = bsxfun(@times,rho,gg2.*g3./(H.*H));

diverted = (H(end,:)==0);
g23or(end,diverted) = inf;

debug_plot = 0;
if debug_plot
eval_debugging_plot(mfilename,'rhotor',[],model,gauss, g3, 'g3', H, 'H', gg2, 'gg2', g23or, 'g23or');
end


return
