function [betap,dbetap_dx] = eval_betap(x,g,v,model)
% function [betap,dbetap_dx] = eval_betap(x,g,v,model)
% #codegen

if nargout>1
  der = true; % compute derivative
  dbetap_dx = zeros(1,numel(x)); % init
else
  der = false;
end

[Wth,dWth_dx] = eval_Wth(x,g,v,model,false);
[Wpol,dWpol_dx] = eval_Wpol(x,g,[],model,false);

betap = (2/3) * Wth(end)/Wpol(end);
if der
  dbetap_dx = (2/3) * ( dWth_dx(end,:)/Wpol(end) - Wth(end)*(1/Wpol(end))^2*dWpol_dx(end,:) );
end

return
