function [rhoin,varargout] = unified_radial_grid(rhodata,varargin)
% [rhoin,varargout] = unified_radial_grid(rhodata,varargin)
% Interpolation from the set of the input radial grids to a unified radial grid
% which can be defined as an input radial grid with maximum length.
% Be careful: rhodata needs to be a normalized rho to allow finding a
% meaningful "unique" rho and how to interpolate in between time points
%
% define radial grid with max length
if iscell(rhodata)
    [~,ind] = max(cellfun(@numel,rhodata));
    rhoin = rhodata{ind};
else
    rhoin = rhodata(:,1);
end

varargout = cell(1,numel(varargin));
% loop to do interpolation from the input radial grids to the unified
% radial grid by using of spline function
for ii=1:numel(varargin)
    x = varargin{ii};        
    nbt = size(x,2);
    if nbt == 1
        varargout{ii} = x;
    else
        if iscell(x)
            for ij=1:nbt
                xout(:,ij) = spline(rhodata{ij},x{ij},rhoin);
            end
        else
            for ij=1:nbt
                xout(:,ij) = spline(rhodata(:,ij),x(:,ij),rhoin);
            end
        end
        varargout{ii} = xout;
        clear xout;
    end
end
return
