function eqrecon = rap_liu_post_processing(params, subiter_info)

L = params.equi.L;

mu0 = 4e-7*pi;
ag2SI = 2*pi*L.dsx;

ng = numel(L.P.wag);
 
nomeas = true;
if params.equi.bfuncspl
  nomeas = false;
  eqrecon.meas.rhopol = sqrt(params.equi.splpsi);
  assert(ng/2==numel(eqrecon.meas.rhopol), 'numel(splpsi) must match ng/2')
end

nt = numel(subiter_info);
eqrecon.rhopol = L.pQ;
nrho = numel(eqrecon.rhopol);
eqrecon.meas.pprime_errorbar = ( L.P.agerr./L.P.wag(1:ng/2) ) / ag2SI;
eqrecon.meas.ttprime_errorbar = ( L.P.agerr./L.P.wag(ng/2+1:end) ) / ag2SI*mu0;

eqrecon.Wk = zeros(1,nt);
eqrecon.Vp = zeros(1,nt);
eqrecon.q95 = zeros(1,nt);
eqrecon.li = zeros(1,nt);
eqrecon.Ip = zeros(1,nt);
eqrecon.psie = zeros(1,nt);
eqrecon.kit = zeros(1,nt);
eqrecon.chi = zeros(1,nt);
eqrecon.res = zeros(1,nt);
eqrecon.pprime = zeros(nrho, nt);
eqrecon.ttprime = zeros(nrho, nt);
eqrecon.jtor = zeros(nrho, nt);
eqrecon.q = zeros(nrho, nt);

if ~nomeas
  eqrecon.meas.pprime = zeros(ng/2, nt);
  eqrecon.meas.ttprime = zeros(ng/2, nt);
end

for it = 1:nt
  eqdata = subiter_info{it}.eq_calls{end};
  eqrecon.Wk(it) = eqdata.data_out.Wk;
  eqrecon.Vp(it) = eqdata.data_out.Vp;
  eqrecon.q95(it) = eqdata.data_out.q95;
  eqrecon.li(it) = eqdata.data_out.li;
  eqrecon.Ip(it) = eqdata.data_out.Ip;
  eqrecon.psie(it) = eqdata.data_out.FB;
  eqrecon.kit(it) = eqdata.data_out.kit;
  eqrecon.chi(it) = eqdata.data_out.chi;
  eqrecon.res(it) = eqdata.data_out.res;
  eqrecon.pprime(:,it) = eqdata.data_out.PpQ;
  eqrecon.ttprime(:,it) = eqdata.data_out.TTpQ;  
  eqrecon.jtor(:,it) = -eqdata.data_out.jtorQ;
  eqrecon.q(:,it) = 1./abs(eqdata.data_out.iqQ);
  if it>1 && ~nomeas && isfield(eqdata.data_in, 'ag')
    eqrecon.meas.pprime(:,it) = eqdata.data_in.ag(1:ng/2)/ag2SI;
    eqrecon.meas.ttprime(:,it) = eqdata.data_in.ag(ng/2+1:end)/ag2SI*mu0;
  end
end
end