function plot_RAPTORgeom_LY(gkii, LYkii, rhotornorm, model)
  g0 = eval_g0([],gkii,[],model,true);
  g1 = eval_g1([],gkii,[],model,true);
  g2 = eval_g2([],gkii,[],model,true);
  g3 = eval_g3([],gkii,[],model,true);
  H = eval_H([],gkii,[],model,true);
  F = eval_F([],gkii,[],model,true);
  Phib = gkii(model.geom.ind_Phib);
  Vol = int_V(1,gkii,model);

  rgauss = model.rgrid.rhogauss;
  figure(101);
  % g0
  subplot(241)
  plot(rhotornorm, LYkii.Q5Q, 'b*-', ...
       rgauss, g0.*H, 'r-.')
  legend({'meq Q5Q*2pi', 'g_0 H'}, 'Location', 'NorthWest')

  % Q4Q vs g1*H^2
  subplot(242)
  plot(rhotornorm, LYkii.Q4Q, 'b*-', ...
       rgauss, g1.*H.^2, 'r-.')
  legend({'meq Q4Q', 'g_1 H^2'}, 'Location', 'NorthWest')

  % Q3Q vs g2*H^2
  subplot(243)
  plot(rhotornorm, LYkii.Q3Q, 'b*-', ...
       rgauss, g2.*H.^2, 'r-.')
  legend({'meq Q3Q', 'g_2 H^2'}, 'Location', 'NorthWest')

  % Q2Q vs g3
  subplot(244)
  plot(rhotornorm, LYkii.Q2Q, 'b*-', ...
       rgauss, g3, 'r-.')
  legend({'meq Q2Q', 'g_3'}, 'Location', 'NorthWest')

  % TQ vs F
  subplot(245)
  plot(rhotornorm, abs(LYkii.TQ), 'b*-', ...
       rgauss, F, 'r-.')
  legend({'meq abs(TQ)', 'F'}, 'Location', 'NorthWest')
  xlabel('rhotornorm')

  % Q1Q vs H
  subplot(246)
  plot(rhotornorm, abs(LYkii.Q1Q), 'b*-', ...
       rgauss, H, 'r-.')
  legend({'meq abs(Q1Q)', 'H'}, 'Location', 'NorthWest')
  xlabel('rhotornorm')

  % FtPQ vs rhotornorm*Phib
  subplot(247)
  plot(rhotornorm, abs(LYkii.FtPQ), 'b*-', ...
       rgauss, rgauss.^2*Phib, 'r-.')
  legend({'meq abs(FtPQ)', 'rhotornorm^2*Phib'}, 'Location', 'NorthWest')
  xlabel('rhotornorm')

  % VpQ vs int_V
  subplot(248)
  plot(rhotornorm, LYkii.VpQ, 'b*-', ...
       model.rgrid.rho, Vol, 'r-.')
  legend({'meq VpQ', 'Vol'}, 'Location', 'NorthWest')
  xlabel('rhotornorm')
  
  set(gcf,'position',[100 100 1000 700]);
  
  return