function plot_RAPTOR_LY_prfcpl(L, LY, rhopsiN, pprime, ttprime, p, q, jtor, Ip, varargin)    
plot_ag = false;
if ~isempty(varargin)
  plot_ag = true;
  mu0 = 4e-7*pi;
  ag2SI = 2*pi*L.dsx;
  psi_ag = varargin{1};
  ag = varargin{2};
  ng = numel(ag);
end
pQ = L.pQ;

figure(100);
subplot(231)
plot(rhopsiN, pprime, pQ, LY.PpQ)
if plot_ag
  hold on
  errorbar(sqrt(psi_ag), ag(1:ng/2)/ag2SI, ( L.P.agerr./L.P.wag(1:ng/2) ) / ag2SI)
  legend({'R pprime','LY.PpQ','agPp'},'Location','NorthWest')
  xlim(sqrt(psi_ag([1 end])))
else
  legend({'R pprime','LY.PpQ'},'Location','NorthWest')
end
xlabel('rhopsiN')
title('pprime')

subplot(232)
plot(rhopsiN, ttprime, pQ, LY.TTpQ)
if plot_ag
  hold on
  errorbar(sqrt(psi_ag), ag(ng/2+1:end)/ag2SI*mu0, ( L.P.agerr./L.P.wag(ng/2+1:end) ) / ag2SI*mu0)
  legend('TTprime','LY.TTpQ','agTTp')
  xlim(sqrt(psi_ag([1 end])))
else
  legend('TTprime','LY.TTpQ')
end
xlabel('rhopsiN')
title('TTprime')

subplot(233)
plot(rhopsiN, jtor, pQ, -LY.jtorQ)
legend({'R','L'},'Location','South')
xlabel('rhopsiN')
title('jtor')

subplot(234)
plot(rhopsiN, Ip, pQ, abs(LY.IpQ))
legend({'R','L'},'Location','NorthWest')
xlabel('rhopsiN')
title('Ip')

subplot(235)
plot(rhopsiN, q, pQ, 1./abs(LY.iqQ))
legend({'R','L'},'Location','NorthWest')
xlabel('rhopsiN')
title('q')

subplot(236)
plot(rhopsiN, p, pQ, LY.PQ)
legend({'R','L'},'Location','South')
xlabel('rhopsiN')
title('P')

set(gcf,'position',[100 100 1100 600]);

end