function [LY] = liut_bf(L, LXk, LYprev, pprime, ttprime, bfuncttp_flag)
% call liuqe with prescribed basis functions 
bfp = prepare_LIUQE_bf(L, sign(LXk.Ip), pprime, ttprime, bfuncttp_flag);

L.P.bfp = bfp;
L.bfp = bfp;

% % obj.LX.ag = zeros(3,numel(obj.LX.t));
% % obj.LX.ag(1,:) = 2*pi*obj.L.dsx;
% % obj.LX.ag(2,:) = 2*pi*obj.L.dsx/mu0;

IyD = LYprev.Iy;
Ie  = [LXk.Ia; LXk.Iu];
% The following ones are just default values
dz  = zeros(L.ndz,1);
aq  = [];
aW  = [];
z0  = 0;
Fnp = [];

LY = liut( L, LXk, 'bfp', bfp, 'rst', false, ...
          'IyD', IyD, 'Ie', Ie, 'dz', dz, 'aq', aq, 'aW', aW, 'z0', z0, 'Fnp', Fnp);

return

function bfp = prepare_LIUQE_bf(L, sIp, pprime, ttprime, bfuncttp_flag)
assert(iscolumn(pprime) && iscolumn(ttprime),'pprime and ttprime must be column vectors');

% Change the sign based on the Ip
sign_multiplier = -sign(sIp);

if bfuncttp_flag
  psiNb = linspace(0,1,numel(L.bfp.gNg(:,2)))';
  psiN = linspace(0,1,numel(pprime))';
  ttp_b1 = interp1(psiNb, L.bfp.gNg(:,2), psiN, 'linear', 'extrap');
  ttp_b2 = interp1(psiNb, L.bfp.gNg(:,3), psiN, 'linear', 'extrap');
  gN1 = sign_multiplier*pprime;
  c = [ttp_b1 ttp_b2]\ ( sign_multiplier*ttprime );
  gN2 = c(1) * ttp_b1;
  gN3 = c(2) * ttp_b2;
  
  fTg = [0;1;1];
else 
  gN1 = sign_multiplier*pprime;
  gN2 = sign_multiplier*ttprime;
  gN3 = 0*pprime;
  
  fTg = [0;1;0];
end

bfp = struct('gNg',...
      [gN1,...
      gN2,...
      gN3],...
     'fPg',[1;0;0],...
     'fTg',fTg);

bfp.IgNg = bfprmex( bfp.gNg );
  
return