function [rhotor,iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta,Phib] = ids2geom(equi)
% get geometry information from IMAS equilibrium IDS

it = 1;
profs = equi.time_slice{it}.profiles_1d;
    
%% read values
% NB: these are all in COCOS=11 by default.

rhotor = profs.rho_tor_norm;

iR2 = profs.gm1; 
iR  = profs.gm9;

if isempty(profs.dvolume_dpsi)
  disp('dvolume_dpsi empty in equil IDS, evaluated with finite differences')
  dvolume_dpsi = zeros(size(profs.volume));
  dvolume_dpsi(1:end-1) = diff(profs.volume)./diff(profs.psi);
  dvolume_dpsi(end) = dvolume_dpsi(end-1);
else
  dvolume_dpsi = profs.dvolume_dpsi;
end
if dvolume_dpsi(1)<0
  disp('dvolume_dpsi negative, sign has been flipped')
  dvolume_dpsi = -1*dvolume_dpsi;
end
if isempty(profs.dpsi_drho_tor)
  disp('dpsi_drho_tor empty in equil IDS, evaluated with finite differences')
  dpsi_drho_tor = zeros(size(profs.psi));
  dpsi_drho_tor(1:end-1) = diff(profs.psi)./diff(profs.rho_tor);
  dpsi_drho_tor(end) = dpsi_drho_tor(end-1);

else
  dpsi_drho_tor = profs.dpsi_drho_tor;
end
if dpsi_drho_tor(1)<0
  disp('dpsi_drho_tor negative, sign has been flipped')
  dpsi_drho_tor = -1*dpsi_drho_tor;
end

dpsidV = 1./dvolume_dpsi; % ok since same eBp in IMAS and RAPTOR
% fix
if dvolume_dpsi(1) == 0 
    dpsidV = spline(rhotor(2:end),dpsidV(2:end),rhotor_ca{it});
end
dpsi = profs.gm7.*dpsi_drho_tor; % dummy to be used later for ne equations
dpsi2 = profs.gm3.*dpsi_drho_tor.^2;
dpsi2oR2 = profs.gm2.*dpsi_drho_tor.^2;

f = profs.f;
if f(1)<0
  disp('dpsi_drho_tor negative, sign has been flipped')
  F = -1*profs.f;
else
  F = profs.f;
end
kappa = profs.elongation;
if isempty(profs.triangularity_lower)
  disp('triangularity_lower empty in equil IDS')
  delta = profs.triangularity_upper;
elseif isempty(profs.triangularity_upper)
  disp('triangularity_upper empty in equil IDS')
  delta = profs.triangularity_lower;
else
  delta = (profs.triangularity_lower+profs.triangularity_upper)/2;
end
Rgeom = (profs.r_outboard + profs.r_inboard)/2;
epsilon = (profs.r_outboard-profs.r_inboard)/2 ./Rgeom;

phiend = profs.phi(end);
if phiend<0
  disp('Phib negative, sign has been flipped')
  Phib(it) = -1*phiend; % scalar
else
  Phib(it) = phiend;
end



end