function [varargout] = conf_params_LIUQE_call(configequi)
  % [config.equi, params.equi, params.numerics.equi] initialized during build_geom.m
  % when liu is computed internally during RAPTOR time iteration

  % use meq version specified in configequi.code_dir
  if isfield(configequi, 'code_dir') && ~isempty(configequi.code_dir)
  	pathCell = regexp(path, pathsep, 'split');
  	for ii=1:numel(pathCell)
      pathii = regexp(pathCell{ii}, '/', 'split');
      if strcmp(pathii{end}, 'meq') && ~strcmp(pathCell{ii}, configequi.code_dir)
      	rmpath(pathCell{ii})
       	addpath(configequi.code_dir)
      	break
      end
    end
  end
  
  % Re-define the equilibrium structure for this particular case
  configequi = struct( ...
      'tokamak',    configequi.tokamak, ...
      'source' ,    configequi.source, ...
      'eq_call',    configequi.eq_call, ...
      'epsilon',    configequi.epsilon, ...
      'kappa',      configequi.kappa, ...
      'delta',      configequi.delta, ...
      'B0',         configequi.B0, ...
      'R0',         configequi.R0, ...
      'Lext',       configequi.Lext, ...
      'gsplineorder', configequi.gsplineorder, ...% polynomial spline order for geometry interpolation
      'gspline_axis_tens', configequi.gspline_axis_tens, ... % Spline tension for geometrical quantities interpolation at the axis
      'gspline_edge_tens', configequi.gspline_axis_tens, ... % spline tension for geometrical quantities interpolation at the edge
      'gknots', configequi.gknots ... % knots for spline fitting of geometrical parameters
      );
  
  
  %% Default parameters for LIUQE call during RAPTOR predictive time iteration
  params = struct();
  
  params.equi.L = []; % Input parameter structure for LIUQE
  params.equi.LX = []; % Input data for LIUQE
  
  params.equi.use_stdliu = 1; % use standard magnetic LIUQE throughout the simulation, rather than providing RAPTOR TT' and p'
  params.equi.cstequi = 0; % maintain equilibrium of it=1 throughout full simulation
  params.equi.bfuncttp = 0; % use 2 basis functions for TT' instead of imposing RAPTOR profile 
  params.equi.bfuncspl = 0; % use set of spline basis functions for p' and TT'
  params.equi.flag_calcPhi = 1; % 1 use calc_Phi.m to calculate Phi; 0: use F (from psiwtcv.m)
  
  %% Define outputs
  varargout = {configequi, params.equi};