function out = TRANSPdata2RAPTORout(rho,time,data)
% out = TRANSPdata2RAPTORout(rho,time,data,param);
% leave 'rho' or 'time' empty to leave data on original grids

% table of correspondence between RAPTOR out terms and TRANSP data
% structure (from gdat)

% raptor name, TRANSP name, scaling
map = {{'ne',     'data.NE.data',1e6},...   ELECTRON DENSITY [N/CM**3 ]
    {'ni'   ,     'data.NI.data',1e6},...   TOTAL ION DENSITY [N/CM**3 ]
    {'te'   ,     'data.TE.data',1},...     ELECTRON TEMPERATURE [EV ]
    {'ti'  ,     'data.TI.data',1},...      ION TEMPERATURE [EV ]
    {'p'  ,     'data.PPLAS.data',1},...    PLASMA PRESSURE [PASCALS ]
    {'ze'  ,      'data.ZEFFI.data',1},...  INPUT ZEFF (UNCONSTRAINED) [ ]
    {'psi'  ,    'data.PLFLX2PI.data',1},...TOTAL POLOIDAL FLUX [Webers ]
    {'upl'  ,    'data.V.data',1},...       VOLTAGE [VOLTS ]
    {'q'  ,      'data.Q.data',1},...       Q PROFILE [ ]
    {'signeo',     '1./data.ETA_USE.data',1e2},... 1/( RESISTIVITY USED OR INFERRED [OHM*CM ] )
    {'chie',     'data.CONDE.data',1e-4},...ELECTRON HEAT DIFFUSIVITY [CM**2/SEC ]
    {'chii',     'data.CONDI.data',1e-4},...ION HEAT DIFFUSIVITY [CM**2/SEC ]
    {'pie',     'data.QIE.data',1e6},...    ION-ELECTRON COUPLING [WATTS/CM3 ]
    {'pnbe' ,     'data.PBE.data',1e6},...  BEAM HEATING OF ELECTRONS [WATTS/CM3 ]
    {'pnbi' ,     'data.PBI.data',1e6},...  BEAM HEATING OF IONS [WATTS/CM3 ]
    {'pici' ,     'data.PIICH.data',1e6},...ICRF ION HEATING [WATTS/CM3 ]
    {'pice' ,     'data.PIECH.data',1e6},...
    {'pec' ,      'data.PEECH.data',1e6},...ECRH ELECTRON HEATING [WATTS/CM3 ]
    {'poh' ,      'data.POH.data',1e6},...  OHMIC HEATING POWER [WATTS/CM3 ]
    {'prad' ,     'data.PRAD.data',1e6},... NET RADIATED POWER [WATTS/CM3 ]
    {'pbrem' ,    'data.PRAD_BR.data',1e6},...BREMSSTRAHLUNG RADIATION [WATTS/CM3 ]
    {'pcycl' ,    'data.PRAD_CY.data',1e6},...CYCLOTRON RADIATION [WATTS/CM3 ]
    {'Pnbe' ,     'cumtrapz(data.DVOL.data .* data.PBE.data)',1},...ZONE VOLUME [CM**3 ]
    {'Pnbi' ,     'cumtrapz(data.DVOL.data .* data.PBI.data)',1},...
    {'Pnb' ,      'cumtrapz(data.DVOL.data .*(data.PBE.data+data.PBI.data))',1},...
    {'Pice' ,     'cumtrapz(data.DVOL.data .* data.PIICH.data)',1},...
    {'Pici' ,     'cumtrapz(data.DVOL.data .* data.PIECH.data)',1},...
    {'Pic' ,      'cumtrapz(data.DVOL.data .*(data.PIECH.data+data.PIICH.data))',1},...
    {'Pec' ,      'cumtrapz(data.DVOL.data .* data.PEECH.data)',1},...
    {'Prad' ,     'cumtrapz(data.DVOL.data .* data.PRAD.data)',1},...
    {'Pbrem' ,    'cumtrapz(data.DVOL.data .* data.PRAD_BR.data)',1},...
    {'Pcycl' ,    'cumtrapz(data.DVOL.data .* data.PRAD_CY.data)',1},...
    {'jpar',      'data.CUR.data',1e4},...   	TOTAL PLASMA CURRENT [AMPS/CM2 ]
    {'jnb' ,      'data.CURB.data',1e4},...   BEAM DRIVEN CURRENT [AMPS/CM2 ]
    {'jbs' ,      'data.CURBS.data',1e4},...  BOOTSTRAP CURRENT [AMPS/CM2 ]
    {'joh' ,      'data.CUROH.data',1e4},...  OHMIC PLASMA CURRENT [AMPS/CM2 ]
    {'jec' ,      'data.ECCUR.data',1e4},...  ECRH CURRENT [A/CM2 ]
    {'Inb' ,      'cumtrapz(data.DAREA.data.*data.CURB.data)',1},...ZONE CROSS SECTIONAL AREA [CM**2 ]
    {'Ibs' ,      'cumtrapz(data.DAREA.data.*data.CURBS.data)',1},...
    {'Ioh' ,      'cumtrapz(data.DAREA.data.*data.CUROH.data)',1},...
    {'Iec' ,      'cumtrapz(data.DAREA.data.*data.ECCUR.data)',1},...
    {'Ip'   ,     'cumtrapz(data.DAREA.data.*data.CUR.data)',1},...
    {'beta'   ,   'data.BTEQ.data',1},...     EQUILIBRIUM BETA(TOROIDAL) [ ]
    {'betapol'   ,   'data.BPEQ.data',1},...  EQUILIBRIUM BETA(POLOIDAL) [ ]
    {'li3'   ,   'data.LIO2C.data',2},...     INDUCTANCE (LI/2) [ ] not sure it's the right one
    {'Phib'   ,   'data.TFLUX.data',1},...    ENCLOSED TOROIDAL FLUX [WEBERS ]
    {'Vp'   ,  'data.DVOL.data/1e6',1},...    1E-6*( ZONE VOLUME [CM**3 ] )
    {'Volume'   ,  'sum(data.DVOL.data/1e6)',1},...
    };

   %% grids - use input grids or keep old ones
   t_transp   = data.TIME.value;
   r_transp = linspace(0,1,40);
   
   if isempty(rho)
       interprho = false;
       out.rho = r_transp;
   else
       interprho = true;
       out.rho = rho;
   end
   
   if isempty(time)
       interptime = false;
       out.time = t_transp';
   else
       interptime = true;
       out.time = time;
   end
   
   out.it=1:numel(out.time);
   out.ntime = numel(out.time);
   out.rho = rho;
   out.nrho = numel(out.rho);
   
   %% interpolate and map to RAPTOR grid
for im=1:numel(map)
    mym = map{im};
    
    try
        transpdata = mym{3}.*full(eval(mym{2}))';
        
        try
            error('check what is happening here')
            transpdata = full(eval(transpdata))';
        end
        
        if length(transpdata(:,1)) ~= length(t_transp)
            transpdata = 0.*t_transp;
        end
        
        % interpolate to new t
        if interptime
            data_on_time = interp1(t_transp,transpdata,out.time,'linear',NaN)';
        else
            data_on_time = transpdata';
        end
        
        
        % if profile data
        if size(transpdata,2)==1 % only time
            out.(mym{1}) = data_on_time';
        else % profile data, interpolate on right rho
            if interprho
                out.(mym{1}) = interp1(r_transp,data_on_time,out.rho,'linear','extrap');
            else
                out.(mym{1}) = data_on_time';
            end
        end
    
    catch err
        if isempty(transpdata)
            warning('%s is empty',mym{2})
        else
            warning('problem while interpolating %s to %s',mym{2}, mym{1});
        end
    end
end
    