function [g1,g2,g3,g23or,Vp] = SI2g(C1,C2,C3,C4,F,Phib,rhotorN)
%% OBSOLETE

% function [g1,g2,g3,g23or,Vp] = SI2g(C1,C2,C3,C4,F,Phib,rhotorN)
% Get raw geometric quantities from CHEASE, transform to profiles
% required by RAPTOR

nbt = size(F,2);

if iscell(C1)
    for ii=1:nbt
    g1{ii} = (4* pi^2) * C1{ii}.* C4{ii};    % <|grad V|^2> 
    g2{ii} = (4* pi^2) * C1{ii}.* C3{ii};    % = <gradV^2/R^2>
    g3{ii} = C2{ii}./ C1{ii};                % = <1/R^2>
    g23or{ii}  = g2{ii}.* g3{ii}./ rhotorN{ii}; % g2*g3/rho
    Vp{ii} = Phib(ii).*(4*pi) * (C1{ii}.* rhotorN{ii})./(F{ii}.* C2{ii}); % dV/drhoN

    % correct boundary condition at rho=0
    if rhotorN{ii}(1)==0
       g1{ii}(1) = 0;
       g2{ii}(1) = 0;
       g23or{ii}(1) = 0;
       Vp{ii}(1) = 0;
    end
    end
else
    for ii=1:nbt
    g1(:,ii) = (4* pi^2) * C1(:,ii).* C4(:,ii);    % <|grad V|^2> 
    g2(:,ii) = (4* pi^2) * C1(:,ii).* C3(:,ii);    % = <gradV^2/R^2>
    g3(:,ii) = C2(:,ii)./ C1(:,ii);                % = <1/R^2>
    g23or(:,ii)  = g2(:,ii).* g3(:,ii)./ rhotorN(:,ii); % g2*g3/rho
    Vp(:,ii) = Phib(ii).*(4*pi) * (C1(:,ii).* rhotorN(:,ii))./(F(:,ii).* C2(:,ii)); % dV/drhoN

    % correct boundary condition at rho=0
    if rhotorN(1,ii)==0
       g1(1,ii) = 0;
       g2(1,ii) = 0;
       g23or(1,ii) = 0;
       Vp(1,ii) = 0;
    end
    end
end

return