function [iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,iota,psib,psia] = LY2geom(LY)

%% Geometry profiles
iR  = LY.Q0Q;           % <1/R>
iR2 = LY.Q2Q;           % <1/R2>
dpsi2oR2 = abs(LY.Q3Q);      % <|dpsi2/R2|>
dpsi2 = abs(LY.Q4Q);         % <|dpsi2|>
iota = abs(LY.iqQ);          % 1/q
dpsidV = abs(LY.Q1Q);        % dpsi/dV
F = abs(LY.TQ);              % F = RBphi
signIp = sign(LY.Ip(1));
psia = -signIp*LY.FA'; 
psib = -signIp*LY.FB'; % axis and boundary psi

dpsi = LY.Q5Q; % <|dpsi|>, Q5Q = <(grad psi)/(2pi)> 
% note factor 1/(2pi) adequate since meq has cocos=17

if psib<psia
	warning('psib<psia in LY');
end


return