function  [g,rhotornorm] = LY2RAPTOR(psiN,LY,geom,gprev,flag_calcPhi,flag_realtime)

[iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,iota,psib,psia] = LY2geom(LY);

% Total toroidal flux
% Phi = - int (q*dPsi) = 1/(2*pi) int( T/R^2 dV)
if flag_calcPhi % use iota
  [Phib,rhotornorm,~] = calcPhi(psiN,iota,psib,psia);
else  % use F (from psiwtcv.m)
  dV = LY.VQ(2:end,:) - LY.VQ(1:end-1,:);
  F = (LY.TQ .* LY.Q2Q)/(2*pi);
  Phi = cumsum([zeros(1,numel(LY.t));0.5*(F(1:end-1,:)+F(2:end,:)).*dV]);
  Phib = Phi(end); 
end

if flag_realtime
  % dummy, substitute later
  epsilon = ones(size(iR2));
  delta = ones(size(iR2));
  kappa = ones(size(iR2));
  Rgeom = ones(size(iR2));
else
  epsilon = LY.epsilon;
  delta = LY.delta;
  kappa = LY.kappa;
  Rgeom = LY.rgeom;
end

g = geom2RAPTOR(rhotornorm,iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta,Phib,geom);

% propagate default epsilon,Rgeom,delta while they are not given by LIUQE
if flag_realtime
  ii = [geom.ind_epsilon, geom.ind_Rgeom, geom.ind_kappa, geom.ind_delta];
  g(ii) = gprev(ii);
end

end