function [iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta,Phib,tgridin,rhotor,config] = IMASequil2SI(config)
% function [iR,iR2,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta,Phib,tgridin,rhotor] = IMASequil2SI(config)
% Loads IMAS equilibrium data from .mat file containing IMAS equilibirum
% IDS data.
% Returns geometric quantities, corresponding time and radial grids.

% Loads IMAS data from .mat file
% and returns geometric quantities, time and radial grids.

% IMAS file name(s)

% to do: remove time loop, dealt with outside
equifiles = config.equi.filenames;
if ~isempty(config.envopts.equil_path)
	equildatapath = config.envopts.equil_path;
else
	equildatapath = fullfile(config.envopts.RAPTOR_path,'equils','imas');
end

nbt = size(equifiles,2);

% time grid for input data
tgridin = config.equi.times;

for ii=1:nbt
  % Check if cheasefile is a cell array
  assert(iscell(equifiles),'config.equi.filenames must contain cell');
  equilfilepath = fullfile(equildatapath,equifiles{ii});

  fprintf('loading CHEASE equilibrium from %s\n',equilfilepath); % verbose for now
  if config.debug.verbosity>2
  	fprintf('loading CHEASE equilibrium from %s\n',equilfilepath);
  end

  if strcmp(equilfilepath(end),'m')
    run(equilfilepath);
  else
    load(equilfilepath); % contains IMAS data for equilibrium
  end
    
  % Magnetic field: constant or time varying parameter
  B0(ii) = abs(equi.vacuum_toroidal_field.b0);
  fprintf('B0 = %2.2f\n',B0(ii));

  % experimental data from eq_params used for scaling
  if ii==1 % for now no time dependence
    R0 = abs(equi.vacuum_toroidal_field.r0);
    fprintf('R0 = %2.2f\n',R0);
  end

  [rhotor,iR_ids,iR2_ids,dpsi_ids,dpsi2_ids,dpsi2oR2_ids, ...
   dpsidV_ids,F_ids,epsilon_ids,Rgeom_ids,kappa_ids,delta_ids,Phib_ids] = ids2geom(equi);

  % ij = 2:numel(iR_ch); done for CHEASE, should we?
  ij= rhotor>0 & rhotor<=1;
  
  % prepare output profiles
  if nbt==1
    iR2 = iR2_ids(ij);
    iR  = iR_ids(ij);
    dpsi = dpsi_ids(ij);
    dpsi2 = dpsi2_ids(ij);
    dpsi2oR2 = dpsi2oR2_ids(ij);
    dpsidV = dpsidV_ids(ij);
    F = F_ids(ij);
    Rgeom = Rgeom_ids(ij);
    epsilon = epsilon_ids(ij);
    kappa = kappa_ids(ij);
    delta = delta_ids(ij);
    Phib(ii) = Phib_ids;
    rhotor = rhotor(ij);
  else
    iR2_ca{ii} = iR2_ids(ij);
    iR_ca{ii}  = iR_ids(ij);
    dpsi_ca{ii} = dpsi_ids(ij);
    dpsi2_ca{ii} = dpsi2_ids(ij);
    dpsi2oR2_ca{ii} = dpsi2oR2_ids(ij);
    dpsidV_ca{ii} = dpsidV_ids(ij);
    F_ca{ii} = F_ids(ij);
    Rgeom_ca{ii} = Rgeom_ids(ij);
    kappa_ca{ii} = kappa_ids(ij);
    epsilon_ca{ii} = epsilon_ids(ij);
    delta_ca{ii} = delta_ids(ij);
    Phib(ii) = Phib_ids;
    rhotor_ca{ii} = rhotor(ij);
  end
end
if nbt>1
  % unified radial grid for input data
  [rhotor,iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta] = ...
      unified_radial_grid(rhotor_ca,iR_ca,iR2_ca,dpsi_ca,dpsi2_ca,dpsi2oR2_ca,dpsidV_ca,F_ca,epsilon_ca,Rgeom_ca,kappa_ca,delta_ca);
end

return
