function out=ASTRAdata2RAPTORout(rho,time,data,tokamak)
% out = ASTRAdata2RAPTORout(rho,time,data,param,tokamak);
% leave 'rho' or 'time' empty to leave data ASTRA on original grids

% table of correspondence between RAPTOR out terms and ASTRA data
% structure

if strcmp(tokamak,'TCV')
map = {{'q'   ,     'data.q'},...               % [-]
       {'iota',     '1./data.q'},...                 % [-]  
       {'shear'   , 'data.shear'},...
       {'q0'   ,    'data.q(1,:)'},...         % [-]
       {'qmin'   ,  'min(data.q)'},...          % [-]
                            {'psi' ,     '[]'},...        % times -2pi?
       {'Upl' ,     'data.upl'},...             % [V]       
       {'te' ,      '1e3*data.te'},...          % [eV]
       {'ti' ,      '1e3*data.ti'},...          % [eV]
       {'ne' ,      '1e19*data.ne'},...         % [m^-3]
       {'ni' ,      '1e19*data.ni'},...         % [m^-3]
                            {'p'  ,      '[]'},...        % Not in data ASTRA, calculate from definition beta?
       {'ze' ,      'data.Zeff'},...            % [-] 
                            {'li3' ,     '[]'},...        % Check if its there 
                            {'betaN' ,   '[]'},...        % Calculate from definition?
                            {'beta' ,    '[]'},...        % Why times 100 in cronos?
       {'signeo',   'data.cc * (1e6)'},...                % unit data.cc is [(\mu \Omega m)^-1]
       {'chie',     'data.he'},...              % [m^2 / s]
                            {'Pbrem',    '[]'},...        % [W], not there
                            {'Prad' ,    '[]'},...        % [W], not there
                            {'Pei' ,     '[]'},...        % [W], not there
                            {'Poh'  ,    '[]'},...        % [W], not there
                            {'Pnb'  ,    '[]'},...        % [W], not there
       {'Pec'  ,    '1e6*data.ecrh_int'},...    % [W] 
                            {'Paux' ,    '[]'},...        % [W], not there
                            {'Palphatot','[]'},...        % [W], not there
                            {'Ploss',    '[]'},...        % [W], not there
                            {'pbrem',    '[]'},...        % [W m-3], not there
                            {'prad',     '[]'},...        % [W m-3], not there
       {'pei',      '1e6 * data.peicl'},...     % [W m-3]
       {'poh',      '1e6 * data.poh'},...       % [W m-3]
                            {'pnb',      '[]'},...        % [W m-3], not there
       {'pec',      '1e6 * data.ecrh'},...      % [W m-3]
       {'paux',     '1e6 * data.pe'},...        % [W m-3]   
                            {'palphae',  '[]'},...        % [W m-3], not there 
                            {'palphai',  '[]'},...        % [W m-3], not there 
                            {'palphatot','[]'},...        % [W m-3], not there 
       {'jec',      '1e6 * data.cd'},...        % [A m^-2]
                            {'jnb',      '[]'},...        % [A m^-2], not there
                            {'jni',      '[]'},...        % [A m^-2], what is this variable????
       {'jaux',     '1e6 * data.cd'},...        % [A m^-2]
                            {'joh',      '[]'},...
       {'jpar',     '1e6 * data.cu'},...        % [A m^-2]
       {'jbs',      '1e6 * data.cubs'},...      % [A m^-2] IN VERSION FEDERICO listed twice
       {'Ip' ,      '1e6 * data.ipl'},...       % [A]
       {'Ioh',      '1e6 * data.iohm'},...      % [A]
       {'Ibs',      '1e6 * data.ibs'},...       % [A]
                            {'Iaux',     '[]'},...        % [A], not there
                            {'Ini',      '[]'},...        % [A], what is this variable????
                            {'Iec',      '[]'},...        % [A], not there
                            {'Inb',      '[]'},...        % [A], not there
                            {'fbs',      '[]'},...        % [-], not there
       {'foh',      'data.iohm./data.itot'},... % [-]
                            {'fni',      '[]'},...        % [-], what is this variable????
       {'tauE',     'data.tau_e'},...           % [s]
       {'We'  ,     '1e6 * data.we'},...        % [J]
       {'Wi'  ,     '1e6 * data.wi'},...        % [J]
                            {'Wth' ,     '[]'},...        % [J], not there
                            {'g1'  ,     '[]'},...        % <|gradV|^2> , I have to choose time index flattop
                            {'g2'  ,     '[]'},...        % <|gradV|^2/R^2>, I have to choose time index flattop
                            {'g3'  ,     '[]'},...        % <1/R^2>, I have to choose time index flattop
       {'Vprime'  , 'data.vr'},...
       };
end

if strcmp(tokamak,'ASDEX')
map = {{'q'   ,     'data.q'},...               % [-]
       {'iota',     '1./data.q'},...                 % [-]  
       {'shear'   , 'data.shear'},...
       {'q0'   ,    'data.q0(1,:)'},...         % [-]
       {'qmin'   ,  'min(data.q)'},...          % [-]
       {'psi' ,     'data.fp'},...              % times -2pi?
       {'Upl' ,     'data.upl'},...             % [V]       
       {'te' ,      '1e3*data.te'},...          % [eV]
       {'ti' ,      '1e3*data.ti'},...          % [eV]
       {'ne' ,      '1e19*data.ne'},...         % [m^-3]
       {'ni' ,      '1e19*data.ni'},...         % [m^-3]
                            {'p'  ,      '[]'},...        % Not in data ASTRA, calculate from definition beta?
       {'ze' ,      'data.zeffr'},...           % [-]
       {'li3' ,     'data.li3'},...             % 
                            {'betaN' ,   '[]'},...        % Calculate from definition?
       {'beta' ,    'data.beta'},...            % [-] Why times 100 in cronos?
       {'signeo',   'data.cc * (1e6)'},...                % unit data.cc is [(\mu \Omega m)^-1]
       {'chie',     'data.he'},...              % [m^2 / s]
                            {'Pbrem',    '[]'},...        % [W], not there
       {'Prad' ,    '1e6*data.pradtot'},...     % [W]
       {'Pei' ,     '1e6*data.pequitot'},...    % [W]
       {'Poh'  ,    '1e6*data.pohtot'},...      % [W]
       {'Pnbe'  ,    '1e6*data.pnbetotr'},...     % [W] % pnbehtotr replaces pnbetot
       {'Pec'  ,    '1e6*data.pechtotr'},...     % [W] % pechtotr replaces pechtot
       {'Paux' ,    '1e6*data.pnbtot+1e6*data.pechtot'},...% [W]
                            {'Palphatot','[]'},...        % [W], not there
                            {'Ploss',    '[]'},...        % [W], not there
                            {'pbrem',    '[]'},...        % [W m-3], not there
       {'prad',     '1e6*data.prade'},...       % [W m-3]
       {'pei',      '1e6 * data.peicl'},...     % [W m-3]
       {'poh',      '1e6 * data.poh'},...       % [W m-3]
                            {'pnb',      '[]'},...        % [W m-3], not there
       {'pec',      '1e6*data.peecr'},...       % [W m-3]
                            {'paux',     '[]'},...        % [W m-3]   
                            {'palphae',  '[]'},...        % [W m-3], not there 
                            {'palphai',  '[]'},...        % [W m-3], not there 
                            {'palphatot','[]'},...        % [W m-3], not there 
                            {'jec',      '[]'},...        % [A m^-2], not there
                            {'jnb',      '[]'},...        % [A m^-2], not there
                            {'jni',      '[]'},...        % [A m^-2], what is this variable????
                            {'jaux',     '[]'},...        % [A m^-2], not there
                            {'joh',      '[]'},...
       {'jpar',     '1e6 * data.cu'},...        % [A m^-2]
       {'jbs',      '1e6 * data.cubs'},...      % [A m^-2] IN VERSION FEDERICO listed twice
       {'Ip' ,      '1e6 * data.itot'},...      % [A]
       {'Ioh',      '1e6 * data.iohm'},...      % [A]
       {'Ibs',      '1e6 * data.ibs'},...       % [A]
       {'Iaux',     '1e6 * data.icd'},...       % [A]
                            {'Ini',      '[]'},...        % [A], what is this variable????
                            {'Iec',      '[]'},...        % [A], not there
                            {'Inb',      '[]'},...        % [A], not there
                            {'fbs',      '[]'},...        % [-], not there
       {'foh',      'data.iohm./data.ipl'},...  % [-]
                            {'fni',      '[]'},...        % [-], what is this variable????
       {'tauE',     'data.tauee'},...           % [s]
       {'We'  ,     '1e6 * data.we(end, :)'},...        % [J] %  data.we(end,:) replaces data.we
       {'Wi'  ,     '1e6 * data.wi(end, :)'},...        % [J] %  data.we(end,:) replaces data.we
                            {'Wth' ,     '[]'},...        % [J], not there
                            {'g1'  ,     '[]'},...        % <|gradV|^2> , I have to choose time index flattop
                            {'g2'  ,     '[]'},...        % <|gradV|^2/R^2>, I have to choose time index flattop
                            {'g3'  ,     '[]'},...        % <1/R^2>, I have to choose time index flattop
       {'Vprime'  , 'data.vr'},...
       {'pnbi'  , '1e6 * data.pibm'},...
       {'pnbe'  , '1e6 * data.pebm'},...
       };
end


   %% grids - use input grids or keep old ones
   t_ASTRA  = data.t + 1.; % ASTRA simulation is 1s time shifted
   r_ASTRA  = data.rhotor(:,end);   % rho grid at last time step
   
   if isempty(rho)
       interprho = false;
       out.rho = r_ASTRA;
   else
       interprho = true;
       out.rho = rho;
   end
   
   if isempty(time)
       interptime = false;
       out.time = t_ASTRA';
   else
       interptime = true;
       out.time = time;
   end
   
   out.it=1:numel(out.time);
   out.ntime = numel(out.time);
   out.rho = rho;
   out.nrho = numel(out.rho);
   
   %% interpolate and map to RAPTOR grid
for im=1:numel(map)
    mym = map{im};
    try
    if isempty( full(eval(mym{2}))' )
            out.(mym{1}) = zeros(out.nrho,out.ntime);
    else
    
    try
    ASTRAdata = full(eval(mym{2}))';
    
    try
        ASTRAdata = full(eval(ASTRAdata))';
    end
    
    if length(ASTRAdata(:,1)) ~= length(t_ASTRA)
        ASTRAdata = 0.*t_ASTRA;
    end

    % interpolate to new t
    if interptime
        data_on_time = interp1(t_ASTRA,ASTRAdata,out.time,'linear','extrap')';
    else
        data_on_time = ASTRAdata';
    end
   
    
    % if profile data
    if size(ASTRAdata,2)==1 % only time
        out.(mym{1}) = data_on_time';
    else % profile data, interpolate on right rho
        if interprho
            out.(mym{1}) = interp1(r_ASTRA,data_on_time,out.rho,'linear','extrap');
        else
            out.(mym{1}) = data_on_time';
        end
    end
    
    catch err
        warning('could not interpolate %s to %s',mym{2}, mym{1});
        rethrow(err)
    end
    end
    end
end
