function [h,dh_dx,dh_du,Rk,T,iT] = diag_te0(x,~,~,~,~,model, stderr)
% synthetic diagnostic for Te measurement at rho=0
% y = g(x) with y = te0 in keV
% stderr: standard deviation on measurement (in keV)

y = x(model.te.xind(1)); % note: this is in keV for order unity

dydx = zeros(1, model.dims.nx);
dydx(model.te.xind(1)) = 1;

h = y;
dh_dx = dydx;
dh_du = zeros(numel(h), model.dims.nu);

Rk = stderr.^2;
T = 1; iT = 1;
end