function [h,dh_dx,dh_du,Rk,T,iT] = diag_te(x,~,v,~,~,model,stderr, varargin)
% synthetic diagnostic for Te measurement on the rho grid (model.rgrid.rho)
% y = g(x) with y = te(rho) in keV
% stderr: standard deviation on measurement (in keV; scalar or vector with entries for various rho)
% varargin: optional input allows to define rhoped = varargin{1} and only
% consider measurements for rho<rhoped (useful for imposed pedestal model where te is fixed for rho>=rhoped)
if isempty(varargin)
  rhoind = 1:model.rgrid.nrho;
else
  rhoped = varargin{1};
  rhoind = model.rgrid.rho<rhoped;
end
scal = model.te.scal;

[y,dydx] = eval_te(x,[],v,model,false);

h = 1./scal*y(rhoind);
dh_dx = 1/scal*dydx(rhoind,:);
dh_du = zeros(numel(h), model.dims.nu);

T  = eye(numel(h));
iT = eye(numel(h));

Rk = T*( diag(stderr.^2) * eye(numel(h)) )*T';

end