function [h,dh_dx,dh_du,Rk,T,iT] = diag_li3(x,g,v,~,~,model, stderr)
% synthetic diagnostic for li3 measurement at rho=1
% y = g(x) with y = li3 at rho=1
% stderr: standard deviation on measurement
scal = 1;

[li3,dli3_dx] = eval_li3(x,g,v,model);
y = li3(end);
dydx = dli3_dx(end,:);

h = 1./scal*y;
dh_dx = 1/scal*dydx;
dh_du = zeros(numel(h), model.dims.nu);

T = 1/scal;
iT = scal;

Rk = T*(stderr.^2 * eye(numel(h)))*T';

end
