function [h,dh_dx,dh_du,Rk,T,iT] = diag_iota(x,g,~,~,~,model,stderr)
% synthetic diagnostic for iota (1./q) measurement on the rho grid (model.rgrid.rho)
% y = g(x) with y = iota(rho)
% stderr: standard deviation on measurement (scalar or vector with entries for various rho)
scal = 1;

[y,dydx] = eval_iota(x,g,[],model,false);

h = 1./scal*y;
dh_dx = 1/scal*dydx;
dh_du = zeros(numel(h), model.dims.nu);

T = 1/scal * eye(numel(h));
iT = scal * eye(numel(h));

Rk = T*( diag(stderr.^2) * eye(numel(h)) )*T';

end