function [C_TS,rho_tor_TS] = forward_TS_matrix(psi_axis,psi_lcfs,psi_equil_k,Opx,pQ,FtPQ,TS_model,RAPTOR_model)

%% Extraction of model parameters from TS_model
nx = RAPTOR_model.dims.nx;
n_TS = TS_model.n_TS;
w_TS      = TS_model.w_TS;
i_grid_TS = TS_model.i_grid_TS;
i_grid_TS_closest = TS_model.i_grid_TS_closest;

%% Preallocation of the matrix C_TS
C_TS = zeros(n_TS,nx);
C_TS_direct = zeros(n_TS,nx);

%% Psi filtered out of TS position and plasma
% Extract psi values correspondent to TS measurements position
psi_bilin_interp = psi_equil_k(i_grid_TS);
psi_TS = sum(w_TS.*psi_bilin_interp,2);

% Normalized psi
psi_norm = (psi_TS - psi_axis)/(psi_lcfs - psi_axis);

%% Intersection between plasma and TS position
% i_grid_equil_TS flags which TS channel is effectively in plasma.
% Using psi_norm<=1, we discard points outside LCFS (toroidal flux is undefined there)
i_grid_equil_TS = Opx(i_grid_TS_closest) & psi_norm<=1;
psi_norm_in_plasma = psi_norm(i_grid_equil_TS);

%% Evaluation of rhotor for each TS point
% Evaluation of toroidal flux on normalized psi (pQ^2 is psi_norm)
Ft_eval = interp1(pQ.^2,FtPQ,psi_norm_in_plasma,'linear','extrap');

% Computation of normalized toroidal coordinate
rho_tor = sqrt(Ft_eval/FtPQ(end));

%% Computation of splines to map the density on the R,Z grid

LAMBDA_tor = interp1(RAPTOR_model.rgrid.rhogauss,...
                     RAPTOR_model.te.Lamgauss,...
                     rho_tor,'linear','extrap')';
                   
% % knots points for matrices
% xkts = RAPTOR_model.rgrid.rho;
% sporder = 3;
% S = splineval(rho_tor,xkts,sporder,[1 0 0]);
% LAMBDA_tor_direct = RAPTOR_model.te.scal*S';                                   

%% Fill only the useful TS data which are inside the LCFS 
C_TS(i_grid_equil_TS, RAPTOR_model.te.xind) = LAMBDA_tor';
% C_TS_direct(i_grid_equil_TS, RAPTOR_model.te.xind) = LAMBDA_tor_direct;                                   


rho_tor_TS = -ones(n_TS,1); % -1 to signal invalid rhotor outside LCFS
rho_tor_TS(i_grid_equil_TS) = rho_tor;

end