function [h,dh_dx,dh_du,Rk,T,iT] = diag_TCV(x,g,v,u,it,model,diaglist,varargin)
% RAPTOR diagnostic definition file
% [h,dh_dx,dh_du,Rk,T,iT] = diag_TCV(x,g,v,u,it,model,diaglist,nchan)
% nchan: (optional) number of channels of profile diagnostics. 
%       Default: all rho grid points.

% initialize
h = zeros(0,1); dh_dx = zeros(0,model.dims.nx); dh_du = zeros(0,model.dims.nu);
Rk = []; T = []; iT = [];

if numel(varargin)>0
    nchan = varargin{1};
else
    nchan = [];
end

for ii=1:numel(diaglist)
    
    switch diaglist{ii}
        case 'Psib'
            [idh,iddh_dx,iddh_du,idRk,idT,idiT] = diag_TCV_Psib(x,g,v,u,it,model);
        case 'Ipl'
            [idh,iddh_dx,iddh_du,idRk,idT,idiT] = diag_TCV_Ipl(x,g,v,u,it,model);
        case 'iota'
            [idh,iddh_dx,iddh_du,idRk,idT,idiT] = diag_TCV_iota(x,g,v,u,it,model,nchan);
        case 'Te'
            [idh,iddh_dx,iddh_du,idRk,idT,idiT] = diag_TCV_Te(x,g,v,u,it,model,nchan);
        otherwise 
            error('invalid diagonstic name')
    end        
     h = [h;idh]; dh_dx = [dh_dx;iddh_dx]; dh_du = [dh_du;iddh_du];
     Rk = blkdiag(Rk,idRk); T = blkdiag(T,idT); iT = blkdiag(iT,idiT);
end

return
