function [hk,dh_dx,dh_du,Rk,sn,T] = diag_TCV_XTe(xk,gk,vk,~,RAPTORmodel,varargin)
%#codegen

% defaults
sn   = 15; % noise standard deviation

% input processing
if numel(varargin) >= 1 && ~isempty(varargin{1})
  sn = varargin{1};
end

%% Te %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% diagnostic parameters
scal = RAPTORmodel.te.scal; % typical scale

irhomeas = 1; % by hand for now (central Te)
[te,dte_dx] = eval_te(xk,gk,vk,RAPTORmodel,false);
yk = te(irhomeas); dyk_dx = dte_dx(irhomeas,:);

% scaling matrix
T = 1/scal*eye(numel(yk));
%iT = scal*eye(numel(yk));

% h (scaled output value)
hk = T*yk;

% dh_dx = [zeros(size(RAPTORmodel.out.CTe(irhomeas,:),1),RAPTORmodel.te.nsp), 1/scal*RAPTORmodel.out.CTe(irhomeas,:)];
dh_dx = T*dyk_dx;

% dh_du
dh_du = T*zeros(numel(hk),RAPTORmodel.dims.nu);

% noise covariance
Rk = sn.^2*T*eye(numel(hk))*T';
return