function [h, dh_dx, dh_du, Rk, T, iT, i_act_chann, rho_tor_TS] = diag_TCV_TeTS_Psib(x,~,~,~,it, LY, model, TS_model, L, Hn, stddev_Hn, psie_diag)
   
  i_act_chann = false(size(Hn,1),1);
  
  %% TS
  [h_TS, dh_dx_TS, dh_du_TS, Rk_TS, T_TS, iT_TS, i_act_chann_TS, rho_tor_TS] = diag_TCV_TeTS(x,[],[],[],it, LY, model, TS_model, L, Hn(1:TS_model.n_TS,:), stddev_Hn(1:TS_model.n_TS,:));
  
  i_act_chann(1:TS_model.n_TS) = i_act_chann_TS;
  
  %% psie
  if psie_diag
    [h_psib,dh_dx_psib,dh_du_psib,Rk_psib] = diag_TCV_Psib(x,[],[],[],model, stddev_Hn(end,it));
    i_act_chann(TS_model.n_TS+1) = 1;
  else
    h_psib = [];
    dh_dx_psib = [];
    dh_du_psib = [];
    Rk_psib = [];
  end
  %%

  h = [h_TS; h_psib];
  dh_dx = [dh_dx_TS; dh_dx_psib];
  dh_du = [dh_du_TS; dh_du_psib];
  Rk = blkdiag(Rk_TS, Rk_psib);
  
  T = T_TS;
  iT = iT_TS;
end