function [h, dh_dx, dh_du, Rk, T, iT, i_act_chann, rho_tor_TS] = diag_TCV_TeTS(x,~,~,~,it, LY, model, TS_model, L, Hn, stddev_Hn)

  i_act_chann = false(size(Hn,1),1);

  tescal = model.te.scal; % typical scale

  nrpsi = numel(L.G.rx);
  nzpsi = numel(L.G.zx);

  Opx = zeros(nrpsi,nzpsi);
  Opx(2:end-1, 2:end-1) = LY.Opy';
  Opx = logical(Opx);
  Opx = Opx(:);
  psi = LY.Fx';
  % R0 = LY.rA;
  % Z0 = LY.zA;
  % RZcp = [R0,Z0]; % R,Z coordinate of the center of the plasma

  % Compute C matrix, mapping spline coeff. with FIR and TS measurements
  [C_TS,rho_tor_TS] = forward_TS_matrix(LY.FA,... psi_axis
                      LY.FB,... psi_lcfs
                      psi(:),...psi(R,Z)
                      Opx,...   plasma mask
                      L.pQ,...  Poloidal rho coord for FtPQ
                      LY.FtPQ,...Toroidal flux
                      TS_model, model);
                    
  i_act_chann(1:TS_model.n_TS) = rho_tor_TS>=0 & Hn(1:TS_model.n_TS,it)>0;                

  y = C_TS*x; % note: this is in keV for order unity

  dydx = C_TS;
  
  h = 1/tescal*y;
  dh_dx = 1/tescal*dydx;
  dh_du = zeros(numel(h), model.dims.nu);

  T = eye(numel(h));
  iT = eye(numel(h));

  serr = stddev_Hn(1:TS_model.n_TS,it);
  Rk = T*diag(serr.^2)*T';
end