
function [h,dh_dx,dh_du,Rk,T,iT] = diag_TCV_Te(x,g,v,u,it,model,nchan)

scal = model.te.scal; % typical scale
serr = 100; % error standard deviation

if ~isempty(nchan)
    if nchan==0
        irhomeas = [];
    else
        % always measurement at 1, others spread evenly elsewhere
        locmeas = [0,(1:nchan-1)/nchan];    % vector of rho locations
        % find corresponding closeby rhogrid points
        irhomeas = min(sum(bsxfun(@gt,locmeas,model.rgrid.rhogauss))+1,numel(model.rgrid.rhogauss));
    end
    gauss = true;
else
    % default: one measurement point per rho grid point
    irhomeas = 1:1:model.rgrid.nrho;
    gauss = false;
end

[te,dte_dx] = eval_te(x,g,v,model,gauss);
dh_dx = 1/scal*dte_dx(irhomeas,:);

h = 1./scal*te(irhomeas);

dh_du = zeros(numel(h),numel(u));

T = 1/scal * eye(numel(h));
iT = scal * eye(numel(h));

%herr = linspace(100,10,numel(h));
%Rk = T*diag(herr.^2)*T';
Rk = T*(serr.^2 * eye(numel(h)))*T';

return