function  [out1] = openloop_controller(varargin)
% Open loop controller. Direct feedthrough of controller input signals to output
%  modify input-output indices to create other routings.
%
%   params = openloop_controller; % get default parameters
%   uout = openloop_controller(x,uin,it,model,params) % run module (NB: only uin is used)


%% DEFAULT PARAMETERS

module_params = struct(......
    'name', 'open loop (direct feedthrough)' ...   % no other parameters
);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Input processing

if nargin == 0,
    out1 = module_params;
    return %empty call, probably to get default structures
elseif nargin==6; % change this depending on number of inputs to module
    [stap,geop,Uin,it,model,params] = deal(varargin{:}); % distribute inputs

    if it==1 % check only on first iteration (comment if unwanted)
        module_params_in = model.controllers.(mfilename).params; % module parameter structure
        module_params = local_procinput(module_params, {module_params_in} ); %convert list to structure, replace default by user-defined values.
    end
else
    error('must call with 0 or 7 inputs');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Do the actual work here

% direct feedthrough!
out1 = Uin(:,it);