# RAPTOR - RApid Plasma Transport Simulator

RAPTOR is a tokamak 1D profile simulation code aimed at rapid simulations and control-oriented applications. It was developed starting in 2011 at CRPP (Currently SPC, Swiss Plasma Center) at EPFL in Lausanne.


The code is currently hosted on [`https://gitlab.epfl.ch/spc/raptor`](https://gitlab.epfl.ch/spc/raptor)


## Getting started

### License agreement
* To use the RAPTOR code, please sign and send to the contact person (see below) the [license agreement](license/Code_transfer_RAPTOR_generic_with_partners_CLA.pdf) found in the `license/` folder.
* As part of this license agreement, upon making modifications available to SPC-EPFL you agree with the terms of the Contributor License Agreement (CLA), which are also in the [`license/`](license) folder. See [`CONTRIBUTING.md`](CONTRIBUTING.md) for details.

### Obtaining the code

#### Get an account on EPFL GitLab
* Ask the code owners (see below) how to proceed
* Setup SSH keys between your machine and `gitlab.epfl.ch` as instructed on the GitLab web interface.

#### Clone repository from git
Depending on your gitlab authentication setup, clone the repository using either (for SSH keys)

```
git clone git@gitlab.epfl.ch:spc/raptor/raptor.git
``` 
OR (for HTTPS access)

```
git clone https://gitlab.epfl.ch/spc/raptor/raptor.git
``` 

More information is available in the GitLab help pages.

### Run the basic tests
The code is currently tested for MATLAB versions 2015a, 2017a and 2019a, but may work on different versions as well.

*  in matlab, type:

```
>> cd tests
>> run_RAPTOR_tests
% this runs the basic tests
```

### Go through the tutorials

```
>> cd ../demos
>> help demos 
% this shows the contents of the /demos directory: 
% a list of TUTORIALS to learn to use the code
% Please do these tutorials one-by-one, 
% in any case we highly recommend doing RAPTOR_tutorial_1.m until _6.m
```

## Contributing
* Contributions/bugfixes are welcome. See the file [CONTRIBUTING.md](CONTRIBUTING.md) for information on how to contribute to the code.

## References
For more information about the code, see these publications:

### General references
- F. Felici et. al. Nuclear Fusion 51(8) 2011, 083052 (interpretative and real-time use) [DOI link](https://doi.org/10.1088/0029-5515/51/8/083052)
- F. Felici et. al. Plasma Physics and Controlled Fusion 54(2), 2012, 025002 (predictive and optimization use) [DOI link](https://doi.org/10.1088/0741-3335/54/2/025002)
- F. Felici et. al. Nuclear Fusion 58 2018, 096006 (multi-channel simulations including Ti and ne..) [DOI link](https://doi.org/10.1088/1741-4326/aac8f0)

Documentation can be found in `/doc/`

### Some other publications using RAPTOR:
- F. Felici, M. de Baar, and M. Steinbuch, “A dynamic state observer for real-time reconstruction of the tokamak plasma profile state and disturbances,” in 2014 American Control Conference, 2014, pp. 4816–4823. [DOI link](https://doi.org/10.1109/ACC.2014.6858781)
- F. Felici et al., “Real-time model-based plasma state estimation, monitoring and integrated control in TCV, ASDEX-Upgrade and ITER.,” in 26th IAEA Fusion Energy Conference, Kyoto, Japan, 2016, p. EX/P8-33.
- C. Piron et al., “Integration of the state observer RAPTOR in the real-time MARTe framework at RFX-mod,” Fusion Eng. Des., vol. 123, pp. 616–619, Nov. 2017. [DOI link](https://doi.org/10.1016/j.fusengdes.2017.02.093)
- A. A. Teplukhina, O. Sauter, F. Felici, A. Merle, and D. Kim, “Simulation of profile evolution from ramp-up to ramp-down and optimization of tokamak plasma termination with the RAPTOR code,” Plasma Phys. Control. Fusion, vol. 59, no. 12, p. 124004, Dec. 2017. [DOI link](https://doi.org/10.1088/1361-6587/aa857e)
- C. Piron et al., “Development of the RAPTOR suite of codes towards real-time reconstruction of JET discharges,” Fusion Eng. Des., vol. 169, p. 112431, Aug. 2021. [DOI link](https://doi.org/10.1016/j.fusengdes.2021.112431)
- O. Kudláček et al., “Developments on actuator management, plasma state reconstruction, and control on ASDEX Upgrade,” Fusion Eng. Des., vol. 171, p. 112563, Oct. 2021. [DOI link](https://doi.org/10.1016/j.fusengdes.2021.112563)
- S. Van Mulders et al., “Rapid optimization of stationary tokamak plasmas in RAPTOR: demonstration for the ITER hybrid scenario with neural network surrogate transport model QLKNN,” Nucl. Fusion, vol. 61, no. 8, p. 086019, Aug. 2021. [DOI link](https://doi.org/10.1088/1741-4326/ac0d12)

## Contact information:

Olivier Sauter (EPFL-SPC): olivier.sauter@epfl.ch



