function RAPTORpath = RAPTOR_path()

RAPTORpath = fileparts(mfilename('fullpath'));

RAPTOR_code_folder = fullfile(RAPTORpath,'code');
if ~is_in_path(RAPTOR_code_folder)
    addpath(genpath(RAPTOR_code_folder));
end

%%% temporary while not all branches contain this folder... 
RAPTOR_modules_folder = fullfile(RAPTORpath,'code','modules');
if ~is_in_path(RAPTOR_modules_folder) && exist(RAPTOR_modules_folder,'dir')
    addpath(genpath(RAPTOR_modules_folder));
end
%%%

RAPTOR_optimization = fullfile(RAPTORpath,'optimization');
if ~is_in_path(RAPTOR_optimization)
    addpath(genpath(RAPTOR_optimization));
end

RAPTOR_lib = fullfile(RAPTORpath,'RT','RAPTOR_lib');
if ~is_in_path(RAPTOR_lib)
  addpath(genpath(RAPTOR_lib))
end

if ~is_in_path(RAPTORpath)
  addpath(RAPTORpath)
end

qlknn_src = fullfile(RAPTORpath,'submodules','QLKNN-fortran','src');
if exist(qlknn_src, 'dir') && ~is_in_path(qlknn_src)
  addpath(qlknn_src)
end

% Octave patches for missing Octave functionalities
if exist('OCTAVE_VERSION', 'builtin')
   addpath(fullfile(RAPTORpath, '_octave'));
end

end

function is_in_path = is_in_path(Folder)
  pathCell = regexp(path, pathsep, 'split');
  if ispc  % Windows is not case-sensitive
    is_in_path = any(strcmpi(Folder, pathCell));
  else
    is_in_path = any(strcmp(Folder, pathCell));
  end
end


