function exliuqe(shot,time)
% Function to run liuqe with different numbers of basis functions for p'
% and TT'. 
% 
% Copyright 2023,2025 Swiss Plasma Center EPFL

% Some color specification for the plots
colors = {'r' 'g' 'b' 'k' 'y' 'm' 'c' };
index_color = 0;

figure;clf;
for naas = 0:2
  for nbbs = 0:2
    if naas==0 && nbbs == 0; continue; end % skip naas = nbbs = 0

    % Run LIUQE with some extra parameters to switch on the q profile (iterq)
    % computation, and forcing the use of a specific number of basis
    % functions (bfp)
    liuargs = {'iterq',50,'bfp',[naas,nbbs],'psichco',1e-8,'pq',[],'npq',18','elomin',.1};
    prefix = sprintf('tcv_%d_liu',shot);
    fileargs = {'pfile',[prefix,'_P'],'gfile',[prefix,'_G'],'xfile',[prefix,'_X']};
    [L,~,LY] = liu('file',shot,time,liuargs{:},fileargs{:});

    % Not with all the basis functions LIUQE will be able to find a
    % solution. Plot just the cases where a solutions is found
    if ~isempty(LY)
      index_color = index_color + 1;
      col = colors{index_color};

      % Plot the LCFS
      set(gcf,'position',[100 100 1000 400]); subplot(141); hold on;
      contour(L.G.rx, L.G.zx, LY.Fx, [LY.FB LY.FB], 'LineColor' , col)
      plot(L.G.rv, L.G.zv, 'k'), xlabel('R [m]'), ylabel('Z [m]'), axis equal

      % Extract the profiles
      rho = L.pQ; % norm. poloidal flux
      q = abs(1./[LY.iqQ]); % safety factor
      P = LY.PQ; % pressure
      T = LY.TQ; % T = r B_{phi}

      % Plot the q profile
      subplot(142); hold on
      plot(rho,q,'-','linewidth',2,'Color' , col, 'DisplayName', ['naas =' num2str(naas) ' nbbs = '  num2str(nbbs)])
      title('q'), xlabel('\rho_{\psi_N}'), ylabel('q [-]'), legend('show')

      % Plot the total pressure profile
      subplot(143); hold on;
      plot(rho,P,'-','linewidth',2,'Color' , col, 'DisplayName', ['naas =' num2str(naas) ' nbbs = '  num2str(nbbs)])
      title('p'), xlabel('\rho_{\psi_N}'), ylabel('p [Pa]')

      % Plot the T profile
      subplot(144); hold on;
      plot(rho,T,'-','linewidth',2,'Color' , col, 'DisplayName', ['naas =' num2str(naas) ' nbbs = '  num2str(nbbs)])
      title('T = rB_{\phi}'), xlabel('\rho_{\psi_N}'), ylabel('T [T.m]')
      drawnow;

    end
  end
end
end


