function [Mxa,Brxa,Bzxa,Cxa,Brpa,Bzpa,Cpa,na] = exgf(G,rp,zp)
% Function to obtain the Green's functions for magnetic field and flux
% quantities from poloidal field coil (E,F) currents from L.G structure.
%
% Copyright 2023,2025 Swiss Plasma Center EPFL

na = numel(G.dima);
[rrx,zzx] = meshgrid(G.rx,G.zx);
% Obtain Green's functions
[Mxa,Brxa,Bzxa,Cxa] = greenem({'mut','br','bz','dbzdr'},rrx,zzx,G.rw,G.zw,G.Twa); % flux, radial B-field, vertical B-field, dB_z/dr
[    Brpa,Bzpa,Cpa] = greenem({      'br','bz','dbzdr'},rp ,zp ,G.rw,G.zw,G.Twa); %       radial B-field, vertical B-field, dB_z/dr
end
