function exfbte(gpid)
% Obtain different FBT equilibria varying the power dissipation weight in 
% the parameter LX.gpid
%
% Copyright 2023,2025 Swiss Plasma Center EPFL

figure;clf;
names = cell(1,numel(gpid));

prefix = 'tcv_102734_fbt';
fileargs = {'pfile',[prefix,'_P'],'gfile',[prefix,'_G'],'xfile',[prefix,'_X']};
[L0,LX0] = fbt('file',102734,[],fileargs{:});

Ia = NaN(L0.G.na,numel(gpid));
for k = 1:numel(gpid)
  names{k} = ['gpid = ' num2str(gpid(k))]; % collect for bar plot
  subplot(2,numel(gpid),k);
  LX = LX0; LX.gpid = gpid(k);
  LY = fbtt(L0,LX); % run FBTE
  Ia(:,k) = LY.Ia;
  meqplott(L0,LY); hold on;
  title(names{k});
  plot(L0.G.rv, L0.G.zv, 'k-'); % plot vessel position
  plot(L0.P.rlia1, L0.P.zlia1, 'bo'); % plot requested points imposed in LSQ cost function
  plot(L0.P.rlim1, L0.P.zlim1, 'ro'); % plot requested points imposed as fixed constraint
  axis equal
end
subplot(212)
bar(Ia); title('PFC currents') % plot of the coil currents
set(gca,'xtick',1:16,'xticklabel',[num2str((1:8)','E%d');num2str((1:8)','F%d')],...
  'xgrid','on');
ylabel('I_a [A]');
legend(names)
end
