
%% Parameters for TCV-like case
Ra = 4*0.0391; La = 4*0.0074; 
Re = 5.5657e-5; Le = 4.5158e-7; Mea = 4.74e-5;
n = -0.5; na = 0.421; ne = 1.027; nea = 1.47;
Ip0 = 200e3; R0 = 0.88; mu0=4e-7*pi; Gamma = 2.5;
dMpadz = 1.32e-4; dMpedz = 8.7931e-7;

%% Model
M = [Le*(1+ne/n) Mea*(1+nea/n)
  Mea*(1+nea/n) La*(1+na/n)];
R = diag([Re,Ra]); b = [0;1];
Cz = 2*R0/(mu0*Ip0*Gamma*n)*[dMpedz,dMpadz];

A = -M\R; B=M\b; C = [Cz;0 1];
sys = ss(A,B,C,0); 
sys.InputName = 'Va';
sys.OutputName = {'z','Ia'};

sysZ = sys(1,:);

% add delay
sysD = sysZ; % system with delay
delay = 1e-3;
sysD.InputDelay=delay;
