%VIZRMEX  Compute volume integrals
% [WP,FT0,VP] = VIZRMEX(FX,OPY,RY,IRY,RBT,DRX,DZX);
% Computes volume integrals on plasma grid from
% Inputs:
%  FX: F(z,r) plasma flux
%  OPY: Plasma domain mapping
%  RY, IRY: Inner grid R and its inverse
%  RBT: vacuum R*BT
%  DRX, DZX: x grid spacing
% Outputs:
%  WP: Poloidal field energy: \int_V B_p^2/2\mu0 dV
%  FT0: Enclosed toroidal flux from vacuum toroidal field: \int_S RB_{\phi0} drdz
%  VP: Plasma volume: \int_V dV
%
% Examples:
%  [Wp  ,Ft   ,Vp  ] = VIZRMEX(Fx,int8(Opy>0)  ,ry,iry,rBt,drx,dzx);
%    computes the integrals over all full domains
%  [WpD ,Ft0D ,VpD ] = VIZRMEX(Fx,int8(Opy==iD),ry,iry,rBt,drx,dzx);
%    computes the integrals over the domain iD
%
% For details, see: [MEQ-redbook]
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function varargout = vizrmex(varargin)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 [varargout{1:nargout}] = vizrmexm(varargin{:});
end
