function dWpdFx = vizrJac(Fx,Opy,iry,drx,dzx)
% function dWpdFx = vizrJac(Fx,Opy,iry,drx,dzx, L)
% Computes dWp dFx Jacobian. Takes some inputs of vizrmex
% Arguments:
%   Fx:   matrix, Flux on x grid
%   Opy:  matrix of uint, plasma domain indicators
%   iry:  vector, inverse of r values on y grid (z direction is omitted)
%   drx:  float, r step size on x grid
%   dzx:  float, z step size on x grid
% returns:
%   dWp_dFx: Matrix, Jacobian of Wp w.r.t. Fx
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

% Compute flux gradient on y grid
dFdr = (Fx(2:end-1,3:end) - Fx(2:end-1,1:end-2))/(2*drx);
dFdz = (Fx(3:end,2:end-1) - Fx(1:end-2,2:end-1))/(2*dzx);

Opy = (Opy>0);
dFdr = dFdr .* Opy .* iry' ./ drx;
dFdz = dFdz .* Opy .* iry' ./ dzx;

dWpdFx = zeros(size(Fx));
dWpdFx(2:end-1, 3:end  ) =                            dFdr;
dWpdFx(2:end-1, 1:end-2) = dWpdFx(2:end-1, 1:end-2) - dFdr;
dWpdFx(3:end  , 2:end-1) = dWpdFx(3:end  , 2:end-1) + dFdz;
dWpdFx(1:end-2, 2:end-1) = dWpdFx(1:end-2, 2:end-1) - dFdz;

dWpdFx = drx*dzx/(4*pi*4e-7*pi) * reshape(dWpdFx,1,numel(Fx));

end
