function xpointmath(H)
% Function for checking some X point mathematics
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

 if nargin == 0, H = [1 .5 ; .5 -2]; end
 
 syms Hrr Hzz Hrz
 pretty(eig([Hrr Hrz ; Hrz Hzz]))
 
 assert(H(1,2)==H(2,1),'not symmetric')
 
 l0 = flipud(eig(H));
 li = sqrt((H(1,1)-H(2,2))^2+4*H(1,2)^2);
 l1 = (H(1,1)+H(2,2)+li*[1;-1])/2;
 l = [l0 l1]
 
 [v0,~] = eig(H); v0 = v0(:,2);
 
 t0 = atan2(v0(2),v0(1));
 if t0 >  pi/2; t0 = t0 - pi; end
 if t0 < -pi/2; t0 = t0 + pi; end
 t1 = atan2(2*H(1,2),H(1,1)-H(2,2))/2;
 t = [t0 t1]
 
 v1 = [cos(t1) ; sin(t1)];
 v2 = [sign(H(1,2))*sqrt(l(1)-H(2,2)); sqrt(l(1)-H(1,1)) ;];
 
 [v0 v1 v2/norm(v2)]
 
 
end
