function convert_to_2017a(mymodel)
% Function for converting Simulink files in previous version to 2017a version
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

%%
release = Simulink.MDLInfo.getReleaseName(mymodel);

if ~strcmp(release,'R2019a')
  error('release must be R2019a, found %s',release);
end

origmodel = which(mymodel);
[filepath,name] = fileparts(origmodel);

model_2019 = fullfile(filepath,sprintf('%s_R2019a.slx',name));

fprintf('copy %s to %s\n',origmodel,model_2019)

assert(~unix(sprintf('cp %s %s',origmodel,model_2019)),'error copying');

fprintf('convert %s to 2017a\n',model_2019)

[~,name_2019] = fileparts(model_2019);
load_system(name_2019);
Simulink.exportToVersion(name_2019,origmodel,'R2017A_SLX');
close_system(name_2019,0); % close without saving