% Compute plasma current distribution Iy(R,Z)
% Inputs = {Fx(R,Z), ipsign, ag}
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.
function [Iy, varargout] = compute_Iy(Fx, ipsign, L, ag)
%% Axis and LCFS flux
[rA,zA,FA,dr2FA,dz2FA,drzFA,rX,zX,FX,~,~,~,...
          rB,zB,FB,lB,lX,Opy] = meqpdom(Fx,ipsign,L.P.isaddl,L);

if isnan(FB)
    % Safe exit for optimization routine
    Iy = NaN(L.nzy, L.nry);
    varargout{1} = NaN;
    return
end
if rB == max(L.G.rl)
   % reject solutions limited touching the outer limiter
   Iy = NaN(L.nzy, L.nry);
   varargout{1} = NaN;
    return
end

%% Plasma current from basis function coefficients
[Tyg,~,~] = L.P.bfct(1,L.P.bfp,Fx,FA,FB,Opy,L.ry,L.iry);
Iy = reshape(Tyg*ag,L.nzy,L.nry);

%% Remove current outside boundary
Iy(~Opy) = 0;

%% Add outputs
if nargout >1
   % I would like to use meqlarg for this purpose but path problem due to fact that it is inside a `private` folder
   out = struct('rA', rA, 'zA', zA, 'FA', FA, 'FB', FB, 'rX', rX, 'zX', zX, 'FX', FX,...
                'rB', rB, 'zB', zB, 'lB', lB, 'lX', lX, 'Opy', Opy,...
                 'Ip', sum(sum(Iy)), 'Tyg', Tyg, 'dr2FA', dr2FA, 'dz2FA', dz2FA, 'drzFA', drzFA);
   varargout{1} = out;
end
return
