classdef vizr_jacobian_test < meq_jacobian_test
  % Test to compare the result of vizrJac with the finite difference
  % Jacobian of Wp (computed in vizrmex)
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    verbosity = 0;
    tok = 'ana';
  end    
  
  properties (ClassSetupParameter)
    shot = struct('circular',1,'diverted',2,'diverted2',3,'squashed',5,...
      meq_jacobian_test.doublets_under_test{:});
  end

  properties (TestParameter)
    convergence_test = struct('false',false,'true',true);
  end
  
  methods(TestClassSetup)
    function get_LLX(testCase,shot)
      % Compute FGS initial guess (FBT solution)
      t = 0;
      testCase.get_fgs_LLX(shot,t);
    end
  end
  
  methods(Test,TestTags={'Jacobian'})
    function vizr_jacobian(testCase,convergence_test)

      L = testCase.L;
      LX = testCase.LX;
      Fx = LX.Fx;

      % Prepare arguments
      fun = @vizrmex;
      x0 = {Fx,int8(LX.Opy==1),L.ry,L.iry,LX.rBt,L.drx,L.dzx};

      % F0 sizes
      szF0 = {1};

      % compute the analytical jacobian
      [dWpdFx] = vizrJac(Fx,int8(LX.Opy==1),L.iry,L.drx,L.dzx);

      % Check Wp derivative with respect to Fx
      names_out = {'Wp'};
      iargout = 1;
      names_in = {'Fx'};
      iargin = 1;
      J0 = {dWpdFx};

      jacfd_args = {'szF0',szF0};

      if convergence_test
        % Test convergence
        epsval = {testCase.meshDeltaFx};
      else
        % Test baseline error
        epsval = {testCase.deltaFx};
      end
      % Call generic function
      testCase.test_analytical_jacobian(...
        fun,x0,J0,jacfd_args,iargout,names_out,iargin,names_in,epsval);
    end
  end
end
