classdef tor_001_tcv_tests < meq_test
  % TCV tests for inclusion of TOR busbars
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    verbosity = 0;
    LX
  end

  properties(ClassSetupParameter)
    shot = {55555};
  end

  methods(TestClassSetup)
    function getLX(testCase,shot)
      % Get measurements only once
      tok = 'tcv';
      t = [0.2,0.3];
      [~,testCase.LX] = liu(tok,shot,t,'sela',{'E','F','G','OH','TOR'},'wIa',[ones(19,1);Inf]);
    end
  end

  properties(TestParameter)
    iterh = {0,10};
    codename = {'liu','lih'}
  end
  
  methods(Test,TestTags={'TCV'})
    function test_reconstruction_tor(testCase,codename,iterh)

      % Since LIH does not use LYall, set it to false to identify
      % non-convergence issues in LIU as well
      args = {'iterh',iterh,'LYall',false};

      % Get handle for the difference code functions
      code = str2func(codename);
      codet = str2func([codename,'t']);

      % 1. Run LIH/LIU without TOR
      LX0 = testCase.LX; tok = lower(LX0.tokamak); shot_ = LX0.shot;
      L0 = code(tok,shot_,[],args{:});
      LX0.Ia(end,:) = []; % Remove TOR measurement
      LY0 = codet(L0,LX0);
      testCase.verifyNotEmpty(LY0,sprintf('%s with TOR did not converge',upper(codename)));

      % 2. Run LIH/LIU with TOR but set measurement to 0
      L1 = code(tok,shot_,[],args{:},'sela',{'E','F','G','OH','TOR'},'wIa',[ones(19,1);Inf]);
      LX1 = testCase.LX;
      LX1.Ia(end,:) = 0;
      LY1 = codet(L1,LX1);
      testCase.verifyNotEmpty(LY1,sprintf('%s with TOR did not converge',upper(codename)));
      
      % Checks
      %  Verify LY is the same, excluding quantities depending on number of
      %  Ia or measurements
      excluded = {'Ia','Iadot','chih','chi','chie','werr','uerr','Va','resy','resC','resp','rese','resFx','cycle'};
      testCase.verifyTrue(structcmp(LY0,LY1,sqrt(eps),excluded))

      % 3. Run LIH/LIU with TOR at its measured value
      L2 = L1;
      LX2 = testCase.LX;
      LY2 = codet(L2,LX2);
      testCase.verifyNotEmpty(LY2,sprintf('%s with TOR did not converge',upper(codename)));
    end
  end
end
