classdef (SharedTestFixtures={meq_fixture,meqscripts_fixture}) ...
    test_repro_Ohm_model < matlab.unittest.TestCase
  % test of the reprocess_Ohm_model function
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    shot = 69194; % One of TCV standard shot
    tstart = 0.1;
    tend = 0.4;
    dt = 5e-3;
    doplot = true;
  end
  
  methods (Test, TestTags = {'fge'})
    function test_running(testCase)
      [ok,msg] = meq_test.check_tok('tcv');
      testCase.assumeTrue(ok,msg);
      
      % Compute equilibrium reconstruction
      [L,LX,LY] = liuqe(testCase.shot,testCase.tstart:testCase.dt:testCase.tend);
      % Test running the reprocess function
      LY = reprocess_Ohm_model(L,LY, 'doplot', testCase.doplot);
    end
  end
end


