classdef (SharedTestFixtures={meq_simulink_fixture}) slxmodels_test < meq_test
% Test properties of simulink .slx models
% using Simulink model advisor
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

properties (TestParameter)
  model = {'liusim'}
end

methods(Test, TestTags={'Simulink','SLX-checks'})
  function modeladvisor_checks(testCase,model) 
    %%
    open_system(model);
    fprintf('\nRunning model advisor checks for %s\n',model);
    ma = Simulink.ModelAdvisor.getModelAdvisor(model);
    ma.deselectCheckAll; ma.deselectCheckForTaskAll;
    ma.selectCheckForTask('_SYSTEM_By Task_Model Referencing');
    ma.selectCheckForTask('_SYSTEM_By Task_Managing Library Links and Variants');
    ma.selectCheckForTask('_SYSTEM_By Task_ModelingUsingBuses');
    ma.selectCheckForTask('_SYSTEM_By Task_File Integrity');
    
    checkedTasks = ma.getSelectedCheckForTask;
    ma.runCheck(checkedTasks);
    checkResultStatus = ma.getCheckResultStatus(checkedTasks); 
    
    if ~all(cell2mat(checkResultStatus))
      failStr = '';
      ifail = find(cell2mat(checkResultStatus));
      for ii=1:numel(ifail)
        failStr = [failStr,...
          sprintf('Failed Model Advisor Check: %s\n',checkedTasks{ifail(ii)})]; %#ok<AGROW>
      end
      testCase.verifyFail(failStr);
    end
    %%
    close_system(model,0);

  end
end

end
