classdef resp_test < meq_test
  % extremely simple test for resp
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    A,B,C,D
    tol
  end
  properties(ClassSetupParameter)
    type = {'single','double'};
  end
  
  methods(TestClassSetup)
    function setup_ABCD(testCase,type)
      no = 4; 
      na = 3;
      nb = 6;
      nc = 8;
      nd = 10;
      testCase.A = cast(rand(no,na),type);
      testCase.B = cast(rand(na,nb),type);
      testCase.C = cast(rand(no,nc),type);
      testCase.D = cast(rand(nc,nd),type);
      
      testCase.tol = sqrt(eps(type));
    end
  end
  
  methods (Test,TestTags={'Unit'})
    function test_resp(testCase)
      % Matlab calculation
      ABCD = [testCase.A*testCase.B testCase.C*testCase.D];

      % Mex calculation
      testCase.verifyEqual(respmex(testCase.A,testCase.B,testCase.C,testCase.D),...
        ABCD,...
        'AbsTol',testCase.tol)
    end
    
  end
end

