classdef q95_test < meq_test
  % tests of q95 calculation
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  methods(Test,TestTags={'Unit'})
    function test_q95_interp(testCase)
      % Verify linear interpolation to rho=sqrt(0.95)
      
      L = liu('ana',1,[]);
      
      % Verify interpolation of rho profile gives exact value.
      testCase.verifyEqual(L.c95*(L.pQ(L.i95)).',sqrt(0.95),'Cannot recover expected value when interpolating to rho=sqrt(0.95)')
    end
  end
end
