classdef meqsize_test < meq_test
  % Test meq output sizes
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    verbose = 0;
    tokamak = 'ana'
  end

  properties(TestParameter)
    shot = {3,81,82} % shots to test
  end

  methods(Test,TestTags={'Integration'})
    function test_all(testCase,shot)
      t = 0;
      tok = testCase.tokamak;
      
      [Lfbt,LXfbt] = fbt(tok,shot,[],...
        'iterq',10, ...
        'debug',testCase.verbose,...
        'nFW',2);
      
      %% Solve FBT
      LYfbt = fbtt(Lfbt,LXfbt);
      testCase.assertNotEmpty(LYfbt,'FBT returned empty structure');
      
      testCase.test_sizes(Lfbt,LYfbt);
      
      %% solve FGS
      [Lfgs] = fgs(tok,shot,t(1),'debug',testCase.verbose,...
        'mkryl',50,'algo','jfnk','tolF',1e-5);
      LXfgs = meqxconvert(Lfbt,LYfbt,Lfgs);
      LYfgs = fgst(Lfgs,LXfgs);

      testCase.test_sizes(Lfgs,LXfgs);
      testCase.test_sizes(Lfgs,LYfgs);
      
      %% Solve LIU
      [Lliu] = liu(tok,shot,t(1),'debug',testCase.verbose,...
        'iterq',10,'nFW',2);
      LXliu = meqxconvert(Lfgs,LYfgs,Lliu);
      LYliu = liut(Lliu,LXliu);
      testCase.assertNotEmpty(LYliu,'LIU returned empty structure');
      
      testCase.test_sizes(Lliu,LYliu);
    end
  end
  
  methods
    function test_sizes(testCase,L,myvar)
      % check variable sizes
      for ifield=fieldnames(myvar)
        myfield = ifield{:};
        testCase.verifyEqual(size(myvar.(myfield)),meqsize(L,myfield),...
          sprintf('%s does not have expected size',myfield));
      end
    end
  end
end

